#include <stdio.h>
#include <stdlib.h>  /* Fichier d'en-tte pour malloc et free. */
#include <string.h>  /* Fichier d'en-tte pour strcpy, strlen et de strcmp. */

/* Type de base d'un lment de liste de personne. */
typedef struct person
{
    char *name;           /* Nom de la personne. */
    char *address;        /* Adresse de la personne. */
    struct person *next;  /* Pointeur sur l'lment suivant. */
} Person;

typedef Person *People;   /* Type de liste de personnes. */

/* Fonctions de gestion des listes de personnes : */

/* Fonction d'initialisation d'une liste de personne.
   La liste est passe par variable pour permettre son initialisation. */
void init_list(People *lst)
{
   *lst = NULL;
}

/* Fonction d'ajout d'une personne. Les paramtres de la personne
   sont passs par variables, mais ne peuvent tre modifis car
   ils sont constants. Ce sont des chanes de caractres C, qui
   sont donc assimiles  des pointeurs de caractres constants. */
int add_person(People *lst, const char *name, const char *address)
{
    /* Cre un nouvel lment : */
    Person *p = (Person *) malloc(sizeof(Person));
    if (p != NULL)
    {
        /* Alloue la mmoire pour le nom et l'adresse. Attention,
           il faut compter le caractre nul terminal des chanes : */
        p->name = (char *) malloc((strlen(name) + 1) * sizeof(char));
        p->address = (char *) malloc((strlen(address) + 1) * sizeof(char));
        if (p->name != NULL && p->address != NULL)
        {
            /* Copie le nom et l'adresse : */
            strcpy(p->name, name);
            strcpy(p->address, address);
            p->next = *lst;
            *lst = p;
        }
        else
        {
            free(p);
            p = NULL;
        }
    }
    return (p != NULL);
}

/* Fonction de suppression d'une personne.
   La structure de la liste est modifie par la suppression
   de l'lment de cette personne. Cela peut impliquer la modification
   du chanage de l'lment prcdent, ou la modification de la tte
   de liste elle-mme. */
int remove_person(People *lst, const char *name)
{
    /* Recherche la personne et son antcdant : */
    Person *prev = NULL;
    Person *p = *lst;
    while (p != NULL)
    {
        /* On sort si l'lment courant est la personne recherche : */
        if (strcmp(p->name, name) == 0)
            break;
        /* On passe  l'lment suivant sinon : */
        prev = p;
        p = p->next;
    }
    if (p != NULL)
    {
        /* La personne a t trouve, on la supprime de la liste : */
        if (prev == NULL)
        {
            /* La personne est en tte de liste, on met  jour
               le pointeur de tte de liste : */
            *lst = p->next;
        }
        else
        {
            /* On met  jour le lien de l'lment prcdent : */
            prev->next = p->next;
        }
        /* et on la dtruit : */
        free(p->name);
        free(p->address);
        free(p);
    }
    return (p != NULL);
}

/* Simple fonction d'affichage. */
void print_list(People const *lst)
{
    Person const *p = *lst;
    int i = 1;
    while (p != NULL)
    {
        printf("Personne %d : %s (%s)\n", i, p->name, p->address);
        p = p->next;
        ++i;
    }
}

/* Fonction de destruction et de libration de la mmoire. */
void destroy_list(People *lst)
{
    while (*lst != NULL)
    {
        Person *p = *lst;
        *lst = p->next;
        free(p->name);
        free(p->address);
        free(p);
    }
    return ;
}

int main(void)
{
    int op = 0;
    size_t s;
    char buffer[16];
    char name[256];
    char address[256];
    /* Cre une liste de personne : */
    People p;
    init_list(&p);
    /* Utilise la liste : */
    do
    {
        printf("Opration (0 = quitter, 1 = ajouter, 2 = supprimer) ?");
        fgets(buffer, 16, stdin);
        buffer[15] = 0;
	op = 3;
        sscanf(buffer, "%d", &op);
        switch (op)
        {
        case 0:
            break;
        case 1:
            printf("Nom : ");
            fgets(name, 256, stdin);   /* Lit le nom. */
            name[255] = 0;             /* Assure que le caractre nul
                                          terminal est crit. */
            s = strlen(name);          /* Supprime l'ventuel saut de ligne. */
            if (name[s - 1] == '\n') name[s - 1] = 0;
            /* Mme opration pour l'adresse : */
            printf("Adresse : ");
            fgets(address, 256, stdin);
            name[255] = 0;
            s = strlen(address);
            if (address[s - 1] == '\n') address[s - 1] = 0;
            add_person(&p, name, address);
            break;
        case 2:
            printf("Nom : ");
            fgets(name, 256, stdin);
            name[255] = 0;
            s = strlen(name);
            if (name[s - 1] == '\n') name[s - 1] = 0;
            if (remove_person(&p, name) == 0)
            {
                printf("Personne inconnue.\n");
            }
            break;
        default:
           printf("Opration invalide\n");
           break;
        }
        if (op != 0) print_list(&p);
    } while (op != 0);
    /* Dtruit la liste : */
    destroy_list(&p);
    return EXIT_SUCCESS;
}

