#include <stdlib.h>
#include <iostream>

using namespace std;

/*************  LA CLASSE ABSTRAITE DE BASE   *****************/

class Object
{
    unsigned long int new_handle(void);

protected:
    unsigned long int h;         // Identifiant de l'objet.

public:
    Object(void);                // Le constructeur.
    virtual ~Object(void);       // Le destructeur virtuel.
    virtual void print(void) const=0; // Fonction virtuelle pure.
    unsigned long int handle(void) const;   // Fonction renvoyant
                                 // le numro d'identification
                                 // de l'objet.
};

// Cette fonction n'est appelable que par la classe Object :

unsigned long int Object::new_handle(void)
{
    static unsigned long int hc = 0;
    return hc = hc + 1;          // hc est l'identifiant courant.
                                 // Il est incrment
}                                //  chaque appel de new_handle.

// Le constructeur de Object doit tre appel par les classes drives :

Object::Object(void)
{
    h = new_handle();            // Trouve un nouvel identifiant.
    return;
}

Object::~Object(void)
{
    return ;
}

unsigned long int Object::handle(void) const
{
    return h;                    // Renvoie le numro de l'objet.
}

/******************** LA CLASSE SAC   ******************/

class Bag : public Object       // La classe sac. Elle hrite
                                // de Object, car un sac peut
                                // en contenir un autre. Le sac
                                // est implment sous la forme
                                // d'une liste chane.
{
    struct BagList
    {
        BagList *next;
        Object  *ptr;
    };

    BagList *head;               // La tte de liste.

public:
    Bag(void);        // Le constructeur : appel celui de Object.
    ~Bag(void);       // Le destructeur.
    void print(void) const; // Fonction d'affichage du sac.
    bool has(unsigned long int) const;
                      // true si le sac contient l'objet.
    bool is_empty(void) const;   // true si le sac est vide.
    void add(Object &);          // Ajoute un objet.
    void remove(Object &);       // Retire un objet.
};

Bag::Bag(void) : Object()
{
    return;  // Ne fait rien d'autre qu'appeler Object&colon;&colon;Object().
}

Bag::~Bag(void)
{
    BagList *tmp = head;   // Dtruit la liste d'objet.
    while (tmp != NULL)
    {
        tmp = tmp->next;
        delete head;
        head = tmp;
    }
    return;
}

void Bag::print(void) const
{
    BagList *tmp = head;
    cout << "Sac n " << handle() << "." << endl;
    cout << "    Contenu :" << endl;
    while (tmp != NULL)
    {
        cout << "\t";        // Indente la sortie des objets.
        tmp->ptr->print();   // Affiche la liste objets.
        tmp = tmp->next;
    }
    return;
}

bool Bag::has(unsigned long int h) const
{
    BagList *tmp = head;
    while (tmp != NULL && tmp->ptr->handle() != h)
        tmp = tmp->next;     // Cherche l'objet.
    return (tmp != NULL);
}

bool Bag::is_empty(void) const
{
    return (head==NULL);
}

void Bag::add(Object &o)
{
    BagList *tmp = new BagList;   // Ajoute un objet  la liste.
    tmp->ptr = &o;
    tmp->next = head;
    head = tmp;
    return;
}

void Bag::remove(Object &o)
{
    BagList *tmp1 = head, *tmp2 = NULL;
    while (tmp1 != NULL && tmp1->ptr->handle() != o.handle())
    {
        tmp2 = tmp1;        // Cherche l'objet.
        tmp1 = tmp1->next;
    }
    if (tmp1!=NULL)         // et le supprime de la liste.
    {
        if (tmp2!=NULL) tmp2->next = tmp1->next;
        else head = tmp1->next;
        delete tmp1;
    }
    return;
}

class MonObjet : public Object
{
	    /*  etc.  */
public:
    void print(void) const
    {
        cout << "Pas de donnes" << endl;
        return ;
    }
};

Bag MonSac;

int main(void)
{
    MonObjet a, b, c;    // Effectue quelques oprations
	                             // avec le sac :
    MonSac.add(a);
    MonSac.add(b);
    MonSac.add(c);
    MonSac.print();
    MonSac.remove(b);
//    MonSac.add(MonSac);  // Un sac peut contenir un sac !
    MonSac.print();      // Attention ! Cet appel est rcursif !
    return EXIT_SUCCESS;
}

