#include <stdlib.h>
#include <stdio.h>

class complexe
{
    friend complexe operator+(const complexe &, const complexe &);
    friend complexe operator-(const complexe &, const complexe &);
    friend complexe operator*(const complexe &, const complexe &);
    friend complexe operator/(const complexe &, const complexe &);
    
    double m_x, m_y;  // Les parties relles et imaginaires.
public:
    // Constructeurs et oprateur de copie :
    complexe(double x=0, double y=0);
    complexe(const complexe &);
    complexe &operator=(const complexe &);
    
    // Fonctions permettant de lire les parties relles
    // et imaginaires :
    double re(void) const;
    double im(void) const;
    
    // Les oprateurs de base:
    complexe &operator+=(const complexe &);
    complexe &operator-=(const complexe &);
    complexe &operator*=(const complexe &);
    complexe &operator/=(const complexe &);
};

complexe::complexe(double x, double y)
{
    m_x = x;
    m_y = y;
    return ;
}

complexe::complexe(const complexe &source)
{
    m_x = source.m_x;
    m_y = source.m_y;
    return ;
}

complexe &complexe::operator=(const complexe &source)
{
    m_x = source.m_x;
    m_y = source.m_y;
    return *this;
}

double complexe::re() const
{
    return m_x;
}

double complexe::im() const
{
    return m_y;
}

complexe &complexe::operator+=(const complexe &c)
{
    m_x += c.m_x;
    m_y += c.m_y;
    return *this;
}

complexe &complexe::operator-=(const complexe &c)
{
    m_x -= c.m_x;
    m_y -= c.m_y;
    return *this;
}

complexe &complexe::operator*=(const complexe &c)
{
    double temp = m_x*c.m_x -m_y*c.m_y;
    m_y = m_x*c.m_y + m_y*c.m_x;
    m_x = temp;
    return *this;
}

complexe &complexe::operator/=(const complexe &c)
{
    double norm = c.m_x*c.m_x + c.m_y*c.m_y;
    double temp = (m_x*c.m_x + m_y*c.m_y) / norm;
    m_y = (-m_x*c.m_y + m_y*c.m_x) / norm;
    m_x = temp;
    return *this;
}


complexe operator+(const complexe &c1, const complexe &c2)
{
    complexe result = c1;
    return result += c2;
}

complexe operator-(const complexe &c1, const complexe &c2)
{
    complexe result = c1;
    return result -= c2;
}

complexe operator*(const complexe &c1, const complexe &c2)
{
    complexe result = c1;
    return result *= c2;
}

complexe operator/(const complexe &c1, const complexe &c2)
{
    complexe result = c1;
    return result /= c2;
}
    
int main(void)
{
    complexe c1(2,3);
    complexe c2(5,6);
    c1 *= c2;
    printf("c1 = %f%+fi.\n", c1.re(), c1.im());
    double d = 2;
    complexe c3 = d*c1;
    printf("c1 = %f%+fi.\n", c3.re(), c3.im());
    return EXIT_SUCCESS;
}

