#include <stdlib.h>

static bool bThrow = false;

class A
{
public:
    A(void)           // Constructeur.
    {
        // Le constructeur est susceptible
        // de lancer une exception :
        if (bThrow) throw 2;
        return ;
    }

    ~A(void)          // Destructeur.
    {
        return ;
    }

    // L'oprateur new suivant utilise le placement.
    // Il reoit en paramtre le pointeur sur le bloc
    //  utiliser pour la requte d'allocation dynamique
    // de mmoire.
    static void *operator new (size_t taille, A *bloc)
    {
        return (void *) bloc;
    }

    // L'oprateur delete suivant est utilis dans les expressions
    // qui utilisent l'oprateur new avec placement ci-dessus,
    // si une exception se produit dans le constructeur.
    static void operator delete(void *p, A *bloc)
    {
        // On ne fait rien, parce que l'oprateur new correspondant
        // n'a pas allou de mmoire.
        return ;
    }

    // Oprateur new et delete normaux :
    static void *operator new(size_t taille)
    {
        return malloc(taille);
    }

    static void operator delete(void *pBlock)
    {
        free(pBlock);
        return ;
    }
};

int main(void)
{
    A *pA=new A;      // Cration d'un objet de classe A.
    pA->~A();         // Appel explicite du destructeur de A.
    bThrow = true;    // Maintenant, le constructeur de A lance
                      // une exception.
    try
    {
        A *pB=new(pA) A;  // Rutilisation de la mmoire de A.
                          // Si une exception a lieu, l'oprateur
                          // delete(void *, A *) avec placement
                          // est utilis.
        delete pB;        // Destruction de l'objet.
    }
    catch (...)
    {
        // L'oprateur delete(void *, A *) ne libre pas la mmoire
        // alloue lors du premier new. Il faut donc quand mme
        // le faire, mais sans delete, car l'objet point par pA
        // est dj dtruit, et celui point par pB n'a pas pu
	// se construire :
        free(pA);
    }
    return EXIT_SUCCESS;
}

