extern int alloue_ressource(const char *);
extern int libere_ressource(int);
extern int consomme(int, int, int);

// Fonction qui rserve trois ressources et effectue
// un travail avec ces trois ressources.
// Retourne 0 si tout s'est bien pass,
// -1 si la premire ressource ne peut tre prise,
// -2 si la deuxime ressource ne peut tre prise,
// -3 si la troisime ressource ne peut tre prie,
// et -1001  -1004 selon le code d'erreur du travail.
// Les ressources sont consommes par le travail
// si celui-ci russit.
int fait_boulot(const char *rsrc1, const char *rsrc2,
    const char *rsrc3)
{
    // Initilise le code de rsultat  la premire
    // erreur possible :
    int res = -1;
    // Alloue la premire ressource :
    int r1 = alloue_ressource(rsrc1);
    if (r1 != 0)
    {
        // Idem avec la deuxime :
        res = -2;
        int r2 = alloue_ressource(rsrc2);
        if (r2 != 0)
        {
            // Idem avec la troisime :
            res = -3;
            int r3 = alloue_ressource(rsrc3);
            if (r3 != 0)
            {
                // OK, on essaie :
                int trv = consomme(r1, r2, r3);
                switch (trv)
                {
                case 0:
                    res = 0;
                    break;
                case 1:
                    res = -1001;
                    break;
                case 2:
                    res = -1002;
                    break;
                case 4:
                    res = -1003;
                    break;
                case 25:
                    res = -1004;
                    break;
                }
                // Il faut librer en cas d'chec :
                if (res != 0)
                    libere_ressource(r3);
            }
            // Libre r2 :
            if (res != 0)
                libere_ressource(r2);
        }
        if (res != 0)
            libere_ressource(r1);
    }
    return res;
}
