#include <stdlib.h>
#include <iostream>
using namespace std;

// Classe de base de toutes les exceptions :
class ExRuntimeError
{
};

// Classe de base des exceptions pouvant se produire
// lors de manipulations de fichiers :
class ExFileError : public ExRuntimeError
{
};

// Classes des erreurs de manipulation des fichiers :
class ExInvalidName : public ExFileError
{
};

class ExEndOfFile : public ExFileError
{
};

class ExNoSpace : public ExFileError
{
};

class ExMediumFull : public ExNoSpace
{
};

class ExFileSizeMaxLimit : public ExNoSpace
{
};

// Fonction faisant un travail quelconque sur un fichier :

void WriteData(const char *szFileName)
{
    // Exemple d'erreur :
    if (szFileName == NULL) throw ExInvalidName();
    else
    {
        // Traitement de la fonction
        // etc.
		
        // Lancement d'une exception :
        throw ExMediumFull();
    }
}

void Save(const char *szFileName)
{
    try
    {
        WriteData(szFileName);
    }
    // Traitement d'un erreur spcifique :
    catch (ExInvalidName &)
    {
        cout << "Impossible de faire la sauvegarde" << endl;
    }
    // Traitement de toutes les autres erreurs en groupe :
    catch (ExFileError &)
    {
        cout << "Erreur d'entre / sortie" << endl;
    }
}

int main(void)
{
    Save(NULL);
    Save("data.dat");
    return EXIT_SUCCESS;
}

