#include <stdlib.h>
#include <iostream>
using namespace std;

template <class T>
class Stack
{
    typedef struct stackitem
    {
        T Item;                 // On utilise le type T comme
        struct stackitem *Next; // si c'tait un type normal.
    } StackItem;
	     
    StackItem *Tete;
		 
public:         // Les fonctions de la pile :
    Stack(void);
    Stack(const Stack<T> &); // La classe est rfrence en indiquant
                             // son type entre crochets ("Stack<T>").
                             // Ici, ce n'est pas une ncessit
                             // cependant.
    ~Stack(void);
    Stack<T> &operator=(const Stack<T> &);
    void push(T);
    T pop(void);
    bool is_empty(void) const;
    void flush(void);
};
 
// Pour les fonctions membres dfinies en dehors de la dclaration
// de la classe, il faut une dclaration de type gnrique :
 
template <class T>
Stack<T>::Stack(void) // La classe est rfrence en indiquant
                      // son type entre crochets ("Stack<T>").
                      // C'est impratif en dehors de la
                      // dclaration de la classe.
{
    Tete = NULL;
    return;
}

template <class T>
Stack<T>::Stack(const Stack<T> &Init)
{
    Tete = NULL;
    StackItem *tmp1 = Init.Tete, *tmp2 = NULL;
    while (tmp1!=NULL)
    {
        if (tmp2==NULL)
        {
            Tete= new StackItem;
            tmp2 = Tete;
        }
        else
        {
            tmp2->Next = new StackItem;
            tmp2 = tmp2->Next;
        }
        tmp2->Item = tmp1->Item;
        tmp1 = tmp1->Next;
    }
    if (tmp2!=NULL) tmp2->Next = NULL;
    return;
}

template <class T>
Stack<T>::~Stack(void)
{
    flush();
    return;
}
 
template <class T>
Stack<T> &Stack<T>::operator=(const Stack<T> &Init)
{
    flush();
    StackItem *tmp1 = Init.Tete, *tmp2 = NULL;
    while (tmp1!=NULL)
    {
        if (tmp2==NULL)
        {
            Tete = new StackItem;
            tmp2 = Tete;
        }
        else
        {
            tmp2->Next = new StackItem;
            tmp2 = tmp2->Next;
        }
        tmp2->Item = tmp1->Item;
        tmp1 = tmp1->Next;
    }
    if (tmp2!=NULL) tmp2->Next = NULL;
    return *this;
}
 
template <class T>
void Stack<T>::push(T Item)
{
    StackItem *tmp = new StackItem;
    tmp->Item = Item;
    tmp->Next = Tete;
    Tete = tmp;
    return;
}
template <class T>
T Stack<T>::pop(void)
{
    T tmp;
    StackItem *ptmp = Tete;
    if (Tete!=NULL)
    {
        tmp = Tete->Item;
        Tete = Tete->Next;
        delete ptmp;
    }
    return tmp;
}
 
template <class T>
bool Stack<T>::is_empty(void) const
{
    return (Tete==NULL);
}

template <class T>
void Stack<T>::flush(void)
{
    while (Tete!=NULL) pop();
    return;
}

int main(void)
{
	Stack<int> si;
	si.push(1);
	si.push(2);
	si.push(3);
	si.push(4);
	cout << si.pop() << endl;
	cout << si.pop() << endl;
	si.flush();
	cout << si.is_empty() << endl;
	return EXIT_SUCCESS;
}

