#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "object1.h"

/* Implmentation de la classe object1. */

/* Dfinition de la classe object1 : */
struct _object1
{
    /* Implmentation de l'interface des objets nomms : */
    struct _namedobject m_base;
    /* Structure de donnes de la classe : */
    char *m_szName;
};

/* Table des mthodes de la classe object1 : */
static fnamedobject_t object1_methods =
{
    (destroy_namedobject) &destroy_object1,
    (set_namedobject_name) &set_object1_name,
    (print_namedobject_name) &print_object1_name
};

/* Implmentation des mthodes de la classe objet1 : */
object1_t create_object1(const char *szName)
{
    object1_t obj = (object1_t) malloc(sizeof(struct _object1));
    if (obj != NULL)
    {
        // Initialisation :
        obj->m_base.ops = &object1_methods;
        obj->m_szName = NULL;
        // Appel de la mthode set_name :
        set_object1_name(obj, szName);
    }
    return obj;
}

void destroy_object1(object1_t object)
{
    free(object->m_szName);
    object->m_szName = NULL;
    free(object);
}

void set_object1_name(object1_t object, const char *szName)
{
    char *szNewName = NULL;
    int len = strlen(szName);
    szNewName = (char *) malloc(len + 1);
    if (szNewName != NULL)
    {
        strcpy(szNewName, szName);
        if (object->m_szName != NULL)
            free(object->m_szName);
        object->m_szName = szNewName;
    }
}

void print_object1_name(object1_t object)
{
    if (object->m_szName != NULL)
    {
        printf("%s\n", object->m_szName);
    }
    else
    {
        printf("objet anonyme\n");
    }
}

