#include <iostream>
#include <functional>

using namespace std;

// Fonction template permettant d'appliquer une valeur
//  un foncteur unaire. Cette fonction ne peut pas
// tre utilise avec un foncteur binaire.
template <class Foncteur>
typename Foncteur::result_type applique(
    Foncteur f,
    typename Foncteur::argument_type valeur)
{
    return f(valeur);
}

int main(void)
{
    // Construit un foncteur binaire d'addition d'entiers :
    plus<int> plus_binaire;
    int i;
    for (i = 0; i < 10; ++i)
    {
        // Rduit le foncteur plus_binaire en fixant son
        // premier paramtre  35. Le foncteur unaire obtenu
        // est ensuite utilis avec la fonction applique :
        cout << applique(bind1st(plus_binaire, 35), i) << endl;
    }
    return 0;
}

