#include <iostream>
#include <string>
#include <locale>

using namespace std;

int main(void)
{
    // Fixe la locale globale :
    locale::global(locale(""));
    // Lit une ligne :
    wstring S;
    getline(wcin, S);
    // Rcupre la facette de conversion vers wchar_t :
    const codecvt<wchar_t, char, mbstate_t> &f =
        use_facet<codecvt<wchar_t, char, mbstate_t> >(locale());
    // Effectue la conversion :
    const wchar_t *premier = S.c_str();
    const wchar_t *dernier = premier + S.length();
    const wchar_t *suivant = premier;
    string s;
    char tampon[10];
    char *fincvt = tampon;
    codecvt_base::result r;
    mbstate_t etat = mbstate_t();
    while (premier != dernier)
    {
        // Convertit un morceau de la chane :
        r = f.out(etat, premier, dernier, suivant,
            tampon, tampon+10, fincvt);
        // Vrifie les erreurs possibles :
        if (r == codecvt_base::ok || r == codecvt_base::partial)
            cout << "." << flush;
        else if (r == codecvt_base::noconv)
        {
            cout << "conversion non ncessaire" << endl;
            break;
        }
        else if (r == codecvt_base::error)
        {
            cout << "erreur" << endl;
            cout << suivant - premier << endl;
            cout << fincvt - tampon << endl;
            break ;
        }
        // Rcupre le rsultat et prpare la conversion suivante :
        s.append(tampon, fincvt - tampon);
        premier = suivant;
    }
    cout << endl;
    // Affiche le rsultat :
    cout << s << endl;
    return 0;
}

