#include <iostream>
#include <locale>
#include <clocale>
#include <cstring>

using namespace std;

// Facette destine  remplacer numpunct_byname :
class MyNumpunct_byname :
    public numpunct_byname<char>
{
    // Les noms des valeurs true et false :
    const char *m_truename;
    const char *m_falsename;

public:   
    MyNumpunct_byname(const char* nom) :
        numpunct_byname<char>(nom)
    {
        // Dtermine le nom de la locale active :
        const char *loc = nom;
        if (strcmp(nom, "") == 0)
        {
            // Rcupre le nom de la locale globale active :
            loc = setlocale(0, NULL);
        }
        // Prend en charge les noms franais :
        if (strcmp(loc, "fr_FR") == 0)
        {
            m_truename = "vrai";
            m_falsename = "faux";
        }
        else
        {
            // Pour les autres locales, utilise les noms anglais :
            m_truename = "true";
            m_falsename = "false";
        }
    }
    
protected:
    ~MyNumpunct_byname()
    {
    }
    
    string do_truename() const
    {
        return m_truename;
    }
    
    string do_falsename() const
    {
        return m_falsename;
    }
};

int main(void)
{
    // Fixe la locale globale du programme :
    locale::global(locale(""));
    // Cre une nouvelle locale utilisant notre facette :
    locale l(locale(""), new MyNumpunct_byname(""));
    // Installe cette locale dans le flux de sortie :
    cout.imbue(l);
    // Affiche deux boolens :
    cout << boolalpha << true << endl;
    cout << false << endl;
    return 0;
}

