#include <iostream>
#include <queue>

using namespace std;

// Type des donnes stockes dans la file :
struct A
{
    int k;         // Priorit
    const char *t; // Valeur
    A() : k(0), t(0) {}
    A(int k, const char *t) : k(k), t(t) {}
};

// Foncteur de comparaison selon les priorits :
class C
{
public:
    bool operator()(const A &a1, const A &a2)
    {
        return a1.k < a2.k ;
    }
};

int main(void)
{
    // Construit quelques objets :
    A a1(1, "Priorit faible");
    A a2(2, "Priorit moyenne 1");
    A a3(2, "Priorit moyenne 2");
    A a4(3, "Priorit haute 1");
    A a5(3, "Priorit haute 2");
    // Construit une file de priorit :
    priority_queue<A, vector<A>, C> pq;
    // Ajoute les lments :
    pq.push(a5);
    pq.push(a3);
    pq.push(a1);
    pq.push(a2);
    pq.push(a4);
    // Rcupre les lments par ordre de priorit :
    while (!pq.empty())
    {
        cout << pq.top().t << endl;
        pq.pop();
    }
    return 0;
}

