#include <iostream>
#include <string>
#include <algorithm>

using namespace std;

struct A
{
    int numero;   // Numro unique de l'lment
    string nom;   // Nom de l'lment

    A(const char *s) :
        nom(s)
    {
        // Affecte un nouveau numro :
        static int i=0;
        numero = ++i;
    }

    // Oprateur de classement :
    bool operator<(const A &a) const
    {
        return (numero < a.numero);
    }
    
    // Oprateur d'galit (jamais utilis) :
    bool operator==(const A &a) const
    {
        return (nom == a.nom);
    }
};

int main(void)
{
    // Construit un tableau d'lments tris
    // (par construction, puisque le numro est incrment
    //  chaque nouvel objet) :
    A t[5] = {"Jean", "Marc", "Alain", "Ariane", "Sophie"};
    // Cette instance a le mme nom que t[1]
    // mais ne sera pas trouv car son numro est diffrent :
    A test("Marc");
    // Effectue la recherche de test dans le tableau :
    if (binary_search(t, t+5, test))
    {
        cout << "(" << test.numero << ", " <<
            test.nom << ") a t trouv" << endl;
    }
    else
    {
        cout << "(" << test.numero << ", " <<
            test.nom << ") n'a pas t trouv" << endl;
    }
    return 0;
}

